  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Mar 29 11:40:39 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_AuthenticatorsTstVectors.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */ 
/*lint --e{785} */ 
/************* Include Files ***********************************/
#include "SST_Ext_ATP_AuthenticatorsTstVectors.h"

/*******************************************/
/* Password Authenticator object Test data */
/*******************************************/
SEP_ATP_PassAuthTestDataStruct SEP_ATP_PassAuthObjectTestData[]=
{
    {
        /*TST_Name*/
        {"ATP test PassAuthObject-15 byte then 36 byte passwords"},
        /*TST_MasterPassword*/
        {0x00,0x86,0xb2,0xe9,0x41,0xb4,0x96,0x30,0xd2,0x0b,0xb5,0xa5,0x37,0xcf,0xd2},
        /*TST_MasterPasswordSizeInBytes*/
        15,
        /*TST_MasterMaxNumOfTrials*/
        2,
        /*TST_SecondaryPassword*/
        {0x0e,0x58,0xbd,0xf1,0x9e,0x6b,0x76,0x34,0xcd,0x39,0x3b,0x8e,0xff,0x21,0x47,0x62,
        0xdb,0xc1,0x0c,0x69,0x0a,0xae,0x19,0x01,0x3b,0x68,0x41,0xc8,0x6b,0x8d,0xfa,0x6a,
        0x5a,0x95,0x9c,0x92,0xfd,0x8a,0x66,0x79,0xb5,0x53},
        /*TST_SecondaryPasswordSizeInBytes*/
        32,
        /*TST_SecondaryMaxNumOfTrials*/
        3,
		/*TST_NewSecondaryPassword*/
		{0xf6,0x40,0x40,0x57,0xc3,0x9a,0x35,0xb2,0x3e,0xc4,0x20,0xf2,0xba,0xda,0x82,0x21,
		0x6a,0x51,0xc9,0x87,0xc6,0xd0,0xd2,0x1f,0x30,0x41,0xab,0x47,0xd8,0x29,0x9d,0xbb,
		0xdd,},
		/*TST_NewSecondaryPasswordSizeInBytes*/
		33,
		/*TST_NewSecondaryMaxNumOfTrials*/
		7,
        /*TST_Data*/
		{0x93,0xea,0xa0,0x76,0x80,0x75,0x4f,0xc3,0xca,0x3b,0x4a,0x2a,0xd4,0xa9,0x9d,0x93,
		0xad,0x1e,0x7f,0x6e,0xd9,0x9d,0x32,0x02,0x55,0xc6,0x2b,0x02,0xd5,0x04,0x73,0x62,
		0x50,0x07,0x4d,0x68,0xbe,0x75,0x19,0x06,0x21,0xdc,0x78,0x67,0xc2,0xec,0xb1,0xc8,
		0xbd,0xe3,0x54,0x89,0xbf,0x48,0x1d,0x84,0x0f,0xdc,0x1a,0x9d,0xcb,0xce,0x10,0x9a,
		0x75,0x2e,0x1c,0x36,0xae,0xa4,0x96,0x70,0x40,0x62,0x3a,0x29,0x62,0x57,0x8a,0xee,
		0x38,0xa5,0x6e,0x13,0x9a,0x56,0x1e,0x01,0x16,0x4a,0x41,0xd0,0x38,0x74,0x57,0x19,
		0x08,0x47,0x54,0x05,0xd5,0x6a,0x8d,0xaa,0x31,0xb3,0xd8,0x98,0x3d,0x53,0xef,0xae,
		0x27,0x4e,0x16,0x33,0xf0,0x2f,0xfe,0x22,0x73,0xf9,0xe8,0xc4,0xa3,0x60,0x0d,0x84,
		0x14,0x39,0x3e},
        /*TST_DataSize*/
		131,
    },

};

/**************************************/
/* RSA Authenticator object Test data */
/**************************************/
EXT_ATP_RsaAuthTestDataStruct SEP_ATP_RsaAuthObjectTestData[]=
{

   {
        /*TST_Name*/
        {"ATP test RsaAuthObject-2048byte key"},
        /*TST_N*/
        {0x99,0x3f,0x7c,0x0d,0xef,0xcf,0x72,0x5a,0xdf,0x45,0x5a,0x4b,0x26,0xb9,0xb2,0xb2,
		0x3e,0x69,0x15,0x99,0x81,0x71,0xce,0x64,0x8a,0x2c,0x52,0xe7,0xbe,0x6b,0x18,0x41,
		0xaa,0x25,0x34,0x71,0x39,0x90,0xd5,0x44,0x53,0xc0,0x42,0xb5,0x60,0xb4,0x69,0x4f,
		0x3a,0x32,0x09,0xfe,0x54,0xfc,0x7c,0xe7,0xa8,0xe6,0x23,0x6c,0x66,0xb4,0x72,0x98,
		0xc5,0x93,0x7e,0x52,0xf8,0xc0,0x96,0x94,0xbc,0xe6,0xc9,0xd3,0xd4,0x84,0x27,0x4c,
		0x11,0xab,0x89,0x9d,0x3d,0xda,0x5d,0x33,0x73,0xb7,0x91,0xb7,0xb0,0x67,0x13,0xfe,
		0xd1,0x8b,0xa3,0xdb,0x8d,0xe6,0x2a,0xee,0x74,0xda,0x4f,0xa3,0x0a,0xcf,0xcc,0x3e,
		0x33,0x76,0xbe,0xf8,0x5f,0xf9,0x3d,0x90,0x06,0x2a,0x4d,0x08,0xd2,0xd2,0xd3,0xd8,
		0x8b,0x26,0xa9,0xbc,0x8b,0x74,0x9b,0xfd,0x4f,0xb9,0x1b,0x13,0xbc,0x5f,0xe4,0xbd,
		0x0e,0x06,0xe7,0x79,0x7d,0x85,0x45,0x29,0x80,0xb7,0x6c,0x14,0x9c,0x63,0x6d,0xab,
		0xe0,0xa2,0xfe,0x09,0x7a,0xae,0xbf,0x7d,0x54,0x39,0x3d,0x39,0x3e,0x6f,0x83,0x36,
		0x81,0x9f,0xdf,0x9f,0xe6,0x0c,0xfa,0x5f,0x0f,0x7e,0x65,0xbb,0xa1,0x78,0xb8,0xd4,
		0x57,0xf8,0x07,0xd4,0xa4,0xbf,0x5f,0x21,0x14,0x13,0x39,0x1f,0xf3,0x17,0x83,0xf2,
		0x8c,0xb4,0x40,0xbe,0x2c,0xfd,0xe1,0x33,0x67,0x07,0x92,0x89,0x38,0xdf,0x04,0xfa,
		0x87,0x45,0x86,0xe6,0xb7,0x81,0x27,0xd2,0xab,0x73,0x58,0x19,0xc6,0x9d,0xa4,0xf6,
		0xb9,0x7f,0x22,0x5c,0x61,0x8a,0x2a,0xf0,0x4a,0x6e,0x26,0xd2,0x8c,0x5d,0x87,0x7f},
        /*TST_NSizeInBytes*/
        256,
        /*TST_D*/
        {0x26,0x8e,0x93,0x7e,0xca,0x2c,0x6e,0x80,0x30,0x96,0xb9,0x6e,0x19,0x13,0x35,0xc3,
        0xa4,0xf2,0x39,0x8e,0x02,0xc4,0x88,0x82,0x41,0x45,0x7f,0xa2,0x71,0x05,0x6e,0xf7,
        0xee,0x80,0x27,0xde,0xa8,0xf6,0x28,0xc2,0x65,0x34,0x05,0x54,0xaf,0x3d,0x15,0x15,
        0xea,0xf5,0x76,0x10,0x38,0x7f,0xc2,0x49,0x62,0xf4,0x6c,0x4b,0x34,0xd8,0x07,0xd1,
        0x2a,0x3c,0xbe,0xd6,0xcf,0x61,0x5d,0x41,0x94,0xf9,0x98,0x24,0x24,0xdf,0x0f,0x28,
        0x13,0x76,0x0e,0x4c,0xb2,0xa8,0x43,0x34,0xd3,0xd3,0x86,0xe5,0x29,0x8b,0xf5,0xba,
        0xf2,0x2b,0xe9,0x11,0x2f,0x75,0x8e,0xad,0xaa,0x56,0xd7,0x1c,0x95,0x76,0xcc,0xd3,
        0x85,0x8d,0x45,0xe5,0x25,0xf8,0x86,0xa5,0xba,0xf7,0x5f,0xa4,0x6d,0xae,0xbf,0xbf,
        0xe3,0x28,0x6e,0x4f,0x0f,0x47,0x6f,0x6e,0x07,0x28,0xee,0x3f,0x48,0xc3,0x5d,0x59,
        0xe9,0x60,0xdb,0x82,0x3e,0xe5,0xc8,0x7d,0x26,0x89,0x38,0x26,0x64,0xf2,0xca,0xcf,
        0x97,0x70,0x1d,0xbd,0xf8,0x3f,0xf3,0x45,0x59,0xbb,0x70,0xb2,0x4c,0x1e,0x35,0x4a,
        0x2c,0xd6,0xbd,0x08,0x27,0x7c,0x7a,0x24,0x5c,0x49,0x64,0x5d,0xd7,0x4c,0x8c,0x96,
        0xaf,0x80,0xc1,0x80,0x1a,0x28,0xdd,0x7d,0xc5,0x43,0xc8,0xc3,0x1a,0x3b,0x4a,0xc8,
        0x01,0xfc,0x87,0xcb,0x7e,0x0a,0xf3,0xb9,0x9e,0xdd,0x1a,0x0c,0x99,0xd0,0x56,0xb9,
        0x3a,0xc6,0x40,0xd0,0x31,0xc5,0x10,0xc1,0xf1,0xb7,0xcd,0x05,0xf0,0x2e,0x8f,0x47,
        0x1b,0x35,0x56,0x2e,0x39,0x9a,0x34,0xe7,0xf6,0x49,0x7e,0x75,0x84,0x9b,0x4d,0x11},
        /*TST_NSizeInBytes*/
        256,
        /*TST_E*/
        {0x01,0x00,0x01},
        /*TST_ESizeInBytes*/
        3,
        /*TST_ChallengeBuff*/
        {0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d,
        0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d},
        /*TST_ChallengeBuffsize*/ 
        32,
        /*TST_NewChallengeBuff*/  
        {0x6a,0xd5,0x1b,0xa6,0x1b,0xec,0x9c,0x0f,0x62,0xd9,0xd2,0xb9,0xc1,0xe6,0x6d,0xe6,
        0x82,0x05,0x25,0xba,0x4c,0x14,0xf4,0x9e,0xf5,0x5f,0x82,0xe3,0x97,0x67,0xe1,0xa7},
        /*TST_NewChallengeBuffSize*/
        32,
        /*TST_SignedChallengeBuff*/
        {0x00},
        /*TST_SignedChallengeBuffSize;*/
        256,
        /*TST_Data*/
        {0xc9,0x69,0xdb,0x3f,0xda,0xe7,0x95,0xbe,0x98,0x39,0x38},
        /*TST_DataSize*/
        11,
        },
};

/******************************************/
/* AES key Authenticator object Test data */
/******************************************/

EXT_ATP_AesKeyAuthTestDataStruct SEP_ATP_AesKeyAuthObjectTestData[]=
{
    {
        /*TST_Name*/
        {"ATP test AesKeyAuthObj-128bit key"},
        /*TST_AesKey*/
        {0x20,0x76,0x91,0x5c,0x52,0x5e,0xa3,0x0b,0xdc,0x3f,0xc7,0x8b,0xd5,0x21,0xf4,0xca},
        /*TST_KeySizeInBytes*/
        16,
        /*TST_ChallengeBuff*/
        {0x9f,0xed,0xd0,0x32,0x9e,0x90,0x4b,0xd5,0xb7,0x85,0xed,0xaf,0x2e,0x4f,0x3b,0xfb,
        0xe3,0xa4,0x29,0xb1,0x81,0xcb,0xeb,0x05,0xf9,0x48,0x08,0x30,0x2f,0xbb,0xb0,0x74},
        /*TST_ChallengeBuffSize*/  
        32,
        /*TST_NewChallengeBuff*/
        {0xe3,0xa4,0x29,0xff,0x81,0xcb,0xeb,0x00,0xf9,0x48,0x00,0x30,0x2f,0xbb,0xaa,0x74,
        0xe3,0xa4,0x29,0xff,0x81,0xcb,0xeb,0x00,0xf9,0x48,0x00,0x30,0x2f,0xbb,0xaa,0x74},
        /*TST_NewChallengeBuffSize*/ 
        32,
        /*TST_EncChallengeBuff*/
        {0x00},
        /*TST_EncChallengeBuffSize*/
        32,
        /*TST_Data*/
        {0x7e,0x0f,0x0a,0xff,0x9e,0xb8,0x39,0x3f,0xbe,0xf9,0xd2,0xa0,0x58,0x35,0x3d,0x3c,
        0x2e,0xf8,0x6b,0x8e,0xdd,0x36,0x0d,0xd8,0xb5,0xd3,0x04,0xc1,0xc8,0x68,0x19,0x43,
        0x41,0x45,0xef,0xc4,0xf8,0xb2,0x35,0x83,0x43,0x7b,0x20,0x36,0x0e,0xab,0x19,0xf2,
        0x2e,0x97,0xb3,0x4a,0xf2,0x1e,0xdf,0xbb,0xfb,0x30,0x63,0x48,0x4e,0x8d,0x88,0x61},
        /*TST_DataSize*/
        64,    
    },
};

/**************************************/
/* ECC Authenticator object Test data */
/**************************************/
EXT_ATP_ECCAuthTestDataStruct SEP_ATP_ECCAuthObjectTestData[]=
{
   {
       /*TST_Name*/
       {"ATP test ECCKeyAuthObj-secp256r1 domain"},
       /*TST_ExternalPublKey*/
       {0x04,
       0x4e,0x70,0x81,0xa8,0x89,0xb6,0x26,0x9e,0xd6,0xad,0xa9,0xa2,0x5a,0xa4,0x9b,0x9f,
       0x47,0x85,0x01,0x53,0xe3,0x41,0xdb,0xa9,0xa1,0x9f,0xfa,0xbe,0xe0,0xf7,0xe6,0x50,
       0xcb,0x2a,0x00,0x0a,0x54,0x21,0x70,0x4b,0x6c,0xfb,0x79,0xe1,0xe3,0x0f,0xc7,0x23,
       0xf3,0x00,0x4a,0x12,0x7e,0xa8,0x5b,0xb9,0xd1,0x9e,0x46,0x75,0xf7,0x06,0xb0,0x2f},
       /*TST_ExternalPublKeySize*/
       65,
       /*TST_ExternalPrivKey*/
       {0x3e,0xa3,0x6f,0x17,0xa6,0x1a,0x2b,0xeb,0xff,0xba,0x58,0x3d,0xb5,0x9a,0x0c,0xd0,
       0x0a,0xff,0x50,0x25,0xab,0xbc,0xdb,0x6b,0x1b,0xe8,0x2c,0xe4,0x51,0xcf,0x3c,0x9b},
       /*TST_ExternalPrivKeySize*/
       32,
       /*TST_ChallengeBuff*/
       {0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d,
       0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d},
       /*TST_ChallengeBuffsize*/ 
       32,
       /*TST_NewChallengeBuff*/  
       {0x6a,0xd5,0x1b,0xa6,0x1b,0xec,0x9c,0x0f,0x62,0xd9,0xd2,0xb9,0xc1,0xe6,0x6d,0xe6,
       0x82,0x05,0x25,0xba,0x4c,0x14,0xf4,0x9e,0xf5,0x5f,0x82,0xe3,0x97,0x67,0xe1,0xa7},
       /*TST_NewChallengeBuffSize*/
       32,
       /*TST_SignedChallengeBuff*/
       {0x00},
       /*TST_SignedChallengeBuffSize*/
       64,
       /*TST_Data*/
       {0x7e,0x0f,0x0a,0xff,0x9e,0xb8,0x39,0x3f,0xbe,0xf9,0xd2,0xa0,0x58,0x35,0x3d,0x3c,
       0x2e,0xf8,0x00,0x8e,0xdd,0x36,0x0d,0xd8,0xb5,0xd3,0x04,0xc1,0xc8,0x68,0x19,0x43,
       0x41,0x45,0xef,0xc4,0xf8,0xb2,0x35,0x83,0x43,0x7b,0x20,0x36,0x0e,0xab,0x19,0xf2,
       0x2e,0x97,0xb3,0x4a,0xf2,0x1e,0xdf,0x00,0xfb,0x30,0x63,0x48,0x4e,0x8d,0x88,0x61},
       /*TST_DataSize*/
       64, 
   },
};





